#include <linux/module.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/task.h>
#include <linux/mm.h>
#include <linux/atomic.h>
//add by me
static int pg_stats_show(struct seq_file *m, void *v) {
	struct task_struct *task;

	for_each_process(task) { // Iterate all processes
    	if (!task->mm) continue; // Skip kernel threads

    	seq_printf(m, "[%d]: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
        	task->pid,
        	atomic_long_read(&task->pgd_alloc),
        	atomic_long_read(&task->pgd_free),
        	atomic_long_read(&task->pgd_set),

        	atomic_long_read(&task->pud_alloc),
        	atomic_long_read(&task->pud_free),
        	atomic_long_read(&task->pud_set),

        	atomic_long_read(&task->pmd_alloc),
        	atomic_long_read(&task->pmd_free),
        	atomic_long_read(&task->pmd_set),

        	atomic_long_read(&task->pte_alloc),
        	atomic_long_read(&task->pte_free),
        	atomic_long_read(&task->pte_set)
    	);
	}
	return 0;
}

// Set up proc file operations
static int __init pg_stats_init(void) {
	proc_create_single("pg_stats", 0, NULL, pg_stats_show);
	printk(KERN_INFO "Page Table Statistics Module: Loaded\n");
	return 0;
}

static void __exit pg_stats_exit(void) {
	remove_proc_entry("pg_stats", NULL);
	printk(KERN_INFO "Page Table Statistics Module: Unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Your Name");
MODULE_DESCRIPTION("Page Table Statistics Module");
