#include <linux/fs.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/module.h>

// Define format in /proc/pg_stats 
static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "[%d]: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
                   task->pid,
                   task->pgd_alloc_count, task->pgd_free_count, task->pgd_set_count,
                   task->pud_alloc_count, task->pud_free_count, task->pud_set_count,
                   task->pmd_alloc_count, task->pmd_free_count, task->pmd_set_count,
                   task->pte_alloc_count, task->pte_free_count, task->pte_set_count);
    }
    return 0;
}

// Initilization. Create /proc/pg_stats
static int __init pg_stats_init(void)
{
    struct proc_dir_entry *pde;
    // Create /proc/pg_stats 
    pde = proc_create_single("pg_stats", 0, NULL, pg_stats_show);
    return 0;
}

// exit and delete /proc/pg_stats
static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);