#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/spinlock.h>

static int pg_stats_show(struct seq_file *m, void *v) {
	struct task_struct *task;

	for_each_process(task) {
		seq_printf(m, "[%d]: [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]]\n", task->pid,
				   task->count_alloc_pgd, task->count_free_pgd, task->count_set_pgd,
				   task->count_alloc_pud, task->count_free_pud, task->count_set_pud,
				   task->count_alloc_pmd, task->count_free_pmd, task->count_set_pmd,
				   task->count_alloc_pte, task->count_free_pte, task->count_set_pte);
	}
	return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
	return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_proc_ops = {
	.proc_flags = PROC_ENTRY_PERMANENT,
	.proc_open = pg_stats_open,
	.proc_read_iter = seq_read_iter,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
};

static int __init pg_stats_init(void) {
	proc_create("pg_stats", 0, NULL, &pg_stats_proc_ops);

	return 0;
}

static void __exit pg_stats_exit(void) {
	remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
