#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <signal.h>
#include <string.h>
#include <sys/wait.h>

void sig_handler(int signo) {
    printf("Caught signal %d\n", signo);
}

int main() {
    pid_t pid = getpid();
    printf("PID: %d\n", pid);
    
    // Register signal handler
    signal(SIGSEGV, sig_handler);
    
    // Test 1: Write fault
    printf("Test 1: Write fault\n");
    char *buf1 = malloc(4096);
    memset(buf1, 'A', 4096);
    
    // Test 2: User fault
    printf("Test 2: User fault\n");
    char *buf2 = malloc(4096);
    char tmp = buf2[0];
    printf("Read byte: %c\n", tmp);
    
    // Test 3: COW fault
    printf("Test 3: COW fault\n");
    char *buf3 = malloc(4096);
    memset(buf3, 'B', 4096);
    
    pid_t child = fork();
    if (child == 0) {
        // Child process
        buf3[0] = 'C';
        exit(0);
    } else {
        // Parent process
        wait(NULL);
    }
    
    // Test 4: Mlock fault
    printf("Test 4: Mlock fault\n");
    void *buf4 = mmap(NULL, 4096, PROT_READ | PROT_WRITE, 
                     MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
    if (buf4 != MAP_FAILED) {
        mlock(buf4, 4096);
        ((char*)buf4)[0] = 'D';
        munlock(buf4, 4096);
        munmap(buf4, 4096);
    }
    
    // Test 5: Instruction fault (commented out to avoid crashing)
    printf("Test 5: Instruction fault (skipped)\n");
    // void (*bad_func)() = (void (*)())0x1000;
    // bad_func();
    
    printf("Tests completed. Check /proc/%d/fault_stats\n", pid);
    sleep(30);
    
    free(buf1);
    free(buf2);
    free(buf3);
    return 0;
}