#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/init.h>

#define PROC_NAME "pg_stats"

static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;
    rcu_read_lock();
    for_each_process(task) {
        seq_printf(m, "[%d]: [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]]\n",
            task->pid,
            atomic_long_read(&task->pgd_alloc), atomic_long_read(&task->pgd_free), atomic_long_read(&task->pgd_set),
            atomic_long_read(&task->pud_alloc), atomic_long_read(&task->pud_free), atomic_long_read(&task->pud_set),
            atomic_long_read(&task->pmd_alloc), atomic_long_read(&task->pmd_free), atomic_long_read(&task->pmd_set),
            atomic_long_read(&task->pte_alloc), atomic_long_read(&task->pte_free), atomic_long_read(&task->pte_set));
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_proc_ops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void) {
    proc_create(PROC_NAME, 0, NULL, &pg_stats_proc_ops);
    return 0;
}

static void __exit pg_stats_exit(void) {
    remove_proc_entry(PROC_NAME, NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
