#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/uaccess.h>   
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h> 
#include <linux/seq_file.h>
#include <linux/slab.h>  
#include <linux/fs.h>

static int stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "PID: %d, "
                   "[pgd_alloc: %lu], [pgd_free: %lu], [pgd_set: %lu], "
                   "[pud_alloc: %lu], [pud_free: %lu], [pud_set: %lu], "
                   "[pmd_alloc: %lu], [pmd_free: %lu], [pmd_set: %lu], "
                   "[pte_alloc: %lu], [pte_free: %lu], [pte_set: %lu]\n",
                   task->pid,
                   task->pgd_alloc, task->pgd_free, task->pgd_set,
                   task->pud_alloc, task->pud_free, task->pud_set,
                   task->pmd_alloc, task->pmd_free, task->pmd_set,
                   task->pte_alloc, task->pte_free, task->pte_set);
    }

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open, 
    .proc_read = seq_read,      
    .proc_lseek = seq_lseek,    
    .proc_release = single_release, 
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    pr_info("pg_stats module loaded\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats module unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Your Name");
MODULE_DESCRIPTION("A kernel module that displays page table operation stats in /proc/pg_stats");

