#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *p;

    for_each_process(p) {
        seq_printf(m,
            "[%d]: [[%lu, %lu, %lu]], [[%lu, %lu, %lu]], [[%lu, %lu, %lu]], [[%lu, %lu, %lu]]\n",
            p->pid,
            p->pgd_alloc, p->pgd_free, p->pgd_set,
            p->pud_alloc, p->pud_free, p->pud_set,
            p->pmd_alloc, p->pmd_free, p->pmd_set,
            p->pte_alloc, p->pte_free, p->pte_set);
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    pr_info("pg_stats proc entry created\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats proc entry removed\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("s2103919");
MODULE_DESCRIPTION("Page Table Operation Statistics for Coursework 2");

