#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>

#define PROC_FILENAME "pg_stats"

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task){
        // Skip idle tasks
        if (task->pid == 0)
            continue;
    seq_printf(m, "[%d]: [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]], [[%lu], [%lu], [%lu]] \n",task->pid , task->pgd_alloc, task->pgd_free, task->pgd_set, task->pud_alloc, task->pud_free, task->pud_set, task->pmd_alloc, task->pmd_free, task->pmd_set, task->pte_alloc, task->pte_free, task->pte_set);
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_proc_ops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create(PROC_FILENAME, 0, NULL, &pg_stats_proc_ops);
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry(PROC_FILENAME, NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("S2333318");
MODULE_DESCRIPTION("Module to display page table statistics");