// SPDX-License-Identifier: GPL-2.0
// included above because all the other files in fs/proc do!
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v){

    struct task_struct *task;

    for_each_process(task){
        if(!task->mm){
            continue; //this means that only user space tasks are printed 
        }
        //pgd, pud, pmd, pte
        // alloc, free, set

        seq_printf(m, "%d: [%lu, %lu, %lu], [%lu, %lu, %lu], [%lu, %lu, %lu], [%lu, %lu, %lu]\n",
        task->pid, task->pgd_alloc_counter, task->pgd_free_counter, task->pgd_set_counter,
        task->pud_alloc_counter, task->pud_free_counter, task->pud_set_counter,
        task->pmd_alloc_counter, task->pmd_free_counter, task->pmd_set_counter,
        task->pte_alloc_counter, task->pte_free_counter, task->pte_set_counter);
    } 
    
    return 0;
}

static int __init pg_stats_init(void){

    proc_create_single("pg_stats", 0, NULL, pg_stats_show);
    return 0;
}

static void __exit pg_stats_exit(void){
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
MODULE_LICENSE("GPL"); //told i needed to add this so better safe than sorry?
