#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>

static int pg_stats_proc_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
                        task->tgid,
                        task->pgd_count.alloc,
                        task->pgd_count.free,
                        task->pgd_count.set,
                        task->pud_count.alloc,
                        task->pud_count.free,
                        task->pud_count.set,
                        task->pmd_count.alloc,
                        task->pmd_count.free,
                        task->pmd_count.set,
                        task->pte_count.alloc,
                        task->pte_count.free,
                        task->pte_count.set);
    }
    return 0;
}

static int __init proc_pg_stats_init(void) {
    proc_create_single("pg_stats", 0, NULL, pg_stats_proc_show);
    return 0;
}
fs_initcall(proc_pg_stats_init);