#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/init.h>

// CW2: Task 1

static struct proc_dir_entry *pg_stats_entry;

static int pg_stats_show(struct seq_file *m, void *v)
{
	struct task_struct *task;
	long alloc, free, set;

	rcu_read_lock();
	for_each_process(task) {
		seq_printf(m, "[%d]: ", task->pid);

		alloc = atomic_long_read(&task->pgd_alloc);
		free  = atomic_long_read(&task->pgd_free);
		set   = atomic_long_read(&task->pgd_set);
		seq_printf(m, "[[%ld],[%ld],[%ld]], ", alloc, free, set);

		alloc = atomic_long_read(&task->pud_alloc);
		free  = atomic_long_read(&task->pud_free);
		set   = atomic_long_read(&task->pud_set);
		seq_printf(m, "[[%ld],[%ld],[%ld]], ", alloc, free, set);

		alloc = atomic_long_read(&task->pmd_alloc);
		free  = atomic_long_read(&task->pmd_free);
		set   = atomic_long_read(&task->pmd_set);
		seq_printf(m, "[[%ld],[%ld],[%ld]], ", alloc, free, set);

		alloc = atomic_long_read(&task->pte_alloc);
		free  = atomic_long_read(&task->pte_free);
		set   = atomic_long_read(&task->pte_set);
		seq_printf(m, "[[%ld],[%ld],[%ld]]", alloc, free, set);

		seq_printf(m, "\n");
	}
	rcu_read_unlock();
	return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
	return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
	.proc_open = pg_stats_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
};

static int __init pg_stats_init(void)
{
	pg_stats_entry = proc_create("pg_stats", 0444, NULL, &pg_stats_fops);
	if (!pg_stats_entry) {
		pr_err("Error creating /proc/pg_stats entry\n");
		return -ENOMEM;
	}
	return 0;
}

static void __exit pg_stats_exit(void)
{
	proc_remove(pg_stats_entry);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
