#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/init.h>

#define PROC_NAME "pg_stats"

// Show function for /proc/pg_stats
static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "%d: [[%llu], [%llu], [%llu]]", 
            task->pid, 
            task->pgd_allocate_count, task->pgd_free_count, task->pgd_set_count);
        seq_printf(m, ", [[%llu], [%llu], [%llu]]", 
            task->pud_allocate_count, task->pud_free_count, task->pud_set_count);
        seq_printf(m, ", [[%llu], [%llu], [%llu]]", 
            task->pmd_allocate_count, task->pmd_free_count, task->pmd_set_count);
        seq_printf(m, ", [[%llu], [%llu], [%llu]]\n", 
            task->pte_allocate_count, task->pte_free_count, task->pte_set_count);
        // Add similar lines for PUD, PMD, and PTE
    }
    return 0;
}

// Open function for /proc/pg_stats
static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

// proc_ops structure for the module
static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_release = single_release,
};

// Initialization function for the module
static int __init pg_stats_init(void) {
    proc_create(PROC_NAME, 0, NULL, &pg_stats_fops); // Create the proc entry
    return 0;
}

// Exit function for the module
static void __exit pg_stats_exit(void) {
    remove_proc_entry(PROC_NAME, NULL); // Clean up
}

module_init(pg_stats_init);       // Register the init function
module_exit(pg_stats_exit);       // Register the exit function

MODULE_LICENSE("GPL");            // License information
MODULE_AUTHOR("Orlena Currie");       // Author of the module
MODULE_DESCRIPTION("Page Table Statistics Module");  // Description of the module
