#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>
#include <linux/module.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;
    
    rcu_read_lock();
    for_each_process(task) {
        if (task->mm) {
            seq_printf(m, "%d: [%lu,%lu,%lu], [%lu,%lu,%lu], [%lu,%lu,%lu], [%lu,%lu,%lu]\n",
                task->pid,
                task->pg_stats.pgd_alloc, task->pg_stats.pgd_free, task->pg_stats.pgd_set,
                task->pg_stats.pud_alloc, task->pg_stats.pud_free, task->pg_stats.pud_set,
                task->pg_stats.pmd_alloc, task->pg_stats.pmd_free, task->pg_stats.pmd_set,
                task->pg_stats.pte_alloc, task->pg_stats.pte_free, task->pg_stats.pte_set);
        }
    }
    rcu_read_unlock();
    
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_ops = {
    .proc_open      = pg_stats_open,
    .proc_read      = seq_read,
    .proc_lseek     = seq_lseek,
    .proc_release   = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_ops);
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);