#include <linux/cpumask.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/kernel_stat.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/sched/stat.h>
#include <linux/seq_file.h>
#include <linux/slab.h>
#include <linux/time.h>
#include <linux/time_namespace.h>
#include <linux/irqnr.h>
#include <linux/sched/cputime.h>
#include <linux/tick.h>

static int show_stat(struct seq_file *p, void *v)
{
    struct task_struct *t;
    /* For each PID, print stats */
    for_each_process(t) {
	    if (!t->mm) continue;
        seq_printf(p, "[%d]: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
			t->pid, 
			atomic_long_read(&t->pgd_alloc), 
			atomic_long_read(&t->pgd_free), 
			atomic_long_read(&t->pgd_set), 
			atomic_long_read(&t->pud_alloc), 
			atomic_long_read(&t->pud_free), 
			atomic_long_read(&t->pud_set),
			atomic_long_read(&t->pmd_alloc), 
			atomic_long_read(&t->pmd_free), 
			atomic_long_read(&t->pmd_set), 
			atomic_long_read(&t->pte_alloc),
			atomic_long_read(&t->pte_free), 
			atomic_long_read(&t->pte_set));
    }
    
    return 0;
}

static int stat_open(struct inode *inode, struct file *file)
{
	return single_open(file, show_stat, NULL);
}

static const struct proc_ops pg_stats_ops = {
	// .proc_flags	= PROC_ENTRY_PERMANENT,
	.proc_open	= stat_open,
	.proc_read	= seq_read,
	.proc_lseek	= seq_lseek,
	.proc_release	= single_release,
};

static int __init pg_stats_init(void)
{
	printk(KERN_INFO "initializing pg_stats\n");
	proc_create("pg_stats", 0, NULL, &pg_stats_ops);
	return 0;
}
fs_initcall(pg_stats_init);
