/* Based on youtube tutorial - https://www.youtube.com/watch?v=S9LA054pY4M 
    https://github.com/Johannes4Linux/Linux_Driver_Tutorial_legacy/blob/main/18_procfs/procfs_test.c

*/

#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/task.h>
#include <linux/fs.h>
#include <linux/init.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;
        
    // Iterate through all processes
    for_each_process(task) {
        char* format = "%d: [[%d], [%d], [%d]], [[%d], [%d], [%d]], [[%d], [%d], [%d]], [[%d], [%d], [%d]]\n";
        //  pid: [[pgd_alloc],[pgd_free],[pgd_set]], [[pud_alloc],[pud_free],[pud_set]], [[pmd_alloc], [pmd_free],[pmd_set]], [[pte_alloc],[pte_free],[pte_set]]
        seq_printf(m, format, 
            task->pid, 
            task->pgd_alloc, task->pgd_free, task->pgd_set, 
            task->pud_alloc, task->pud_free, task->pud_set, 
            task->pmd_alloc, task->pmd_free, task->pmd_set,
            task->pte_alloc, task->pte_free, task->pte_set
        );
    }
    
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    pr_info("pg_stats module loaded\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats module unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("s2774646");
MODULE_DESCRIPTION("CW2 - pg_stats memory allocation statistics");