#define _GNU_SOURCE
#include <sys/types.h>
#include <sys/xattr.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[]) {
    if (argc == 1) {
        fprintf(stderr,
            "THIS EXAMPLE PROGRAM TAKES A FILEPATH, AN XATTR KEY, AND A VALUE STRING AS ARGUMENTS.\n"
            "IT THEN SETS THE KEY:VALUE AS AN XATTR FOR THAT FILE.\n");
        return EXIT_FAILURE;
    }
    if (argc != 4) {
        fprintf(stderr, "Usage: %s <filepath> <xattr_key> <value>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *filepath = argv[1];
    const char *key = argv[2];
    const char *value = argv[3];

    if (setxattr(filepath, key, value, strlen(value), 0) == -1) {
        perror("setxattr");
        return EXIT_FAILURE;
    }

    printf("Extended attribute set: %s -> %s = %s\n", filepath, key, value);
    return EXIT_SUCCESS;
}
