#include <linux/sched.h>
#include <linux/sched/task.h>
#include <asm/processor.h>
#include <asm/msr.h>
#include <asm/desc.h>
#include <linux/thread_migrate.h>

int add_arch_info(struct task_struct *task, struct field_arch *arch)
{
	unsigned short fsindex, gsindex;
	unsigned long fs, gs;
	int cpu;

	BUG_ON(!arch);

	cpu = get_cpu();


	savesegment(fs, fsindex);
	if (fsindex) {
		fs = get_desc_base(task->thread.tls_array + task->thread.fsbase);
	} else {
		rdmsrl(MSR_FS_BASE, fs);
	}

	savesegment(gs, gsindex);
	if (gsindex) {
		gs = get_desc_base(task->thread.tls_array + task->thread.gsbase);
	} else {
		rdmsrl(MSR_KERNEL_GS_BASE, gs);
	}

	arch->fs = fs;
	arch->gs = gs;

	put_cpu();

	return 0;
}